;*                                			                                         *
;*    Files required:   m0-4.asm (macros) for NATURAL assembler User Interface       *               
;*************************************************************************************
;*                                                                     			     *
;*    Notes:        hardware PCB 2016/inv2448_b.brd						     *
;*                                                                     		         *
;*************************************************************************************
		list      p=12F683	; list directive to define processor
		#include  ..\m0-4.asm
		config_

#define	E1	0x1000
;#define	TMR07Bit	SystemStatus,7


#define GPIOinit	b'00000011'	; 2,4,5 OUTPUT initiate as LOW
#define TRISIOinit	b'11001011'	; configure 2,4,5 as OUTPUT, 0,1 as INPUT 
#define	OPTIONinit	b'11001000'	; no wakeup, no pullup, clock 1:1
#define ANSELinit 	B'01110011' ; ADC Frc clock, AN0,1 as analog
#define	ADCON0init	b'00000001'	; left justified , AN0, on
#define	ADCON1init	b'00000101'	; left justified , AN1, on
#define PR2init		.40
#define CCPR1Linit  .0
#define CCP1CONinit	b'00000000'	; disable pwm, pwmbits 00
#define T2CONinit   b'00000100'	; switch on TMR2

	cblock	_MINRAM			; start of variables
	 SyS1,CcDelay:2,CcPulse:2
	endc

#define STACK		_MAXRAM	

	nointr683
	init_
;PWRUP	
		eq	SyS1,0
		eq	GPIO,GPIOinit

TC0used = 3							; use 3 bytes of timer for TC0
	cblock
	 TC0:TC0used
	 NmbrEvent0
	endc	 
		EVENT0in	.5000,msec,0xFF ; set time @ 5000 milliseconds
		eq_ NmbrEvent0,=,.15,lit8	; set execution  for EVENT0
TC1used = 2
	cblock
	 TC1:TC1used,NmbrEvent1
	endc
		EVENT1in	1,sec,.12		; MLOOP	 

JMPTable	andlw	0x0F
		addwf	PCL,F
		 goto	EVENT0	
		 goto	EVENT1
		 goto	EVENT2	
		 goto	EVENT3
		 goto	EVENT4
		 goto	EVENT5
		 goto	EVENT6
		 goto	EVENT7
		 goto	EVENT8
		 goto	EVENT9
		 goto	EVENT10
		 goto	EVENT11
		 goto	EVENT12
		 goto	EVENT13
		 goto	EVENT14
		 goto	EVENT15

;	org	0x100
	
MLOOP	clrwdt







;	if_not	TMR0,0			;example for very short periodic events
;	 goto	n64MLO
;	goto	PERIODIC64usec
;exitPERIODIC64usec		
;	if_bit	TMR0,0			; avoid multiple P64u's, wait until bit0 is set
;	 goto	exitPERIODIC64usec
;
;n64MLO	
;	if_bit	TMR0,7			; software emulation of
;	 goto	set7			; timer 0 overflow
;	if_not	TMR07Bit		; PIC 10Fxxx only
;	 goto	set7+1
;
	if_not	INTCON,T0IF		; wait for timer TMR0 to time out
	 goto	MLOOP
	bcf	INTCON,T0IF			
	goto	PERIODIC8		; which is 256*4 us =1 milliseconds
exitPERIODIC8
	decfsz	TC0,F
	 goto	endMLOOP0
;	goto	PERIODIC2048		; after first TC0 expired, 2048 milliseconds 
;exitPERIODIC2048			; have passed
	if TC0used > 1
;	movlw	0x07			;example for very long periodic events
;	andwf	TC0+1,W
;	movwf	STACK
;	movlw	-7
;	addwf	STACK,W
;	skpnZ
;	 goto	PERIODIC16sec		; every 16 seconds (Event0 must be later!)
;exitPERIODIC16sec
	decfsz	TC0+1,F
	 goto	endMLOOP0
	endif
					; after TC0+1 expired, 8 minutes 44 seconds
	if TC0used > 2			; have passed
	decfsz	TC0+2,F
	 goto	endMLOOP0
	endif 
	movfw	NmbrEvent0		; after TC0+2 expired, 37 hours 17 minutes
	goto	JMPTable 		; now jump to loaded Event
	 
endMLOOP0				; and continue execution here	 
end0MLOOP0
	if TC1used > 0
	decfsz	TC1,F			; analogous as TC0
	 goto	endMLOOP1
	endif
	if TC1used > 1
	decfsz	TC1+1,F
	 goto	endMLOOP1
	endif
	if TC1used > 2
	decfsz	TC1+2,F
	 goto	endMLOOP1
	endif 
	if TC1used > 0
	movfw	NmbrEvent1
	goto	JMPTable 
	endif

	goto	endMLOOP1 
	 
	 
set7				;bsf	TMR07Bit	
endMLOOP1	goto	MLOOP

;	org	0x200
;PERIODIC64usec			
;		goto	exitPERIODIC64usec
;
PERIODIC8							; check fuse tripped for 255 times
;	movf	AlarmCount,f
;	skpNZ
;	 goto    exitPERIODIC8			; signal gen is in shutdown
;	if_m	GPIO,3,is_on,1
; 		incfsz	AlarmCount,F
;	      goto	increasedAlarm
;		bcf	GPIO,2
;		bcf	GPIO,1					; Alarm = 0
;		EVENT0in	.3,sec,.4		; shut down! wait 30 sec
;	end_m
;	goto    exitPERIODIC8			; signal gen is running, with Alarm >= 1
;increasedAlarm
;	EVENT1in	.60,msec,0xFF
;	eq_			NmbrEvent1,=,.14,lit8
	goto    exitPERIODIC8			; signal gen is running, but waiting to collect
									; more Alarm, else decrease it in 60msec	
PERIODIC2048	
;		goto	exitPERIODIC2048
		
PERIODIC16sec	
;		goto	exitPERIODIC16sec	



#define	hiSide	SyS1,2		



flflop
	do_	SyS1,=,SyS1,XOR,b'00000100',lit8
    if_m hiSide,is_on,1
	  do_	GPIO,=,GPIO,OR,b'00010000',lit8
	else_m
	  do_	GPIO,=,GPIO,OR,b'00000100',lit8
	end_m
	retlw 0
				 
EVENT0		
	call	flflop
	EVENT0in	.4000,usec,2	
EVENT1	
	do_	GPIO,=,GPIO,AND,b'11001000',lit8
	if_m hiSide,is_on,1
	  bcf	hiSide
	else_m
	  bsf hiSide
	end_m

		goto $					; test

	delay .100
	goto EVENT0
EVENT2			
	bsf	GPIO,5
    EVENT0in	.1000,usec,.3	
EVENT3
    bcf	GPIO,5
    EVENT0in .3800,usec,1
EVENT4							; coming after shut down
	if_m	GPIO,3,is_off,1
;	 eq_ AlarmCount,=,.1,lit8
     EVENT0in	.300,msec,.5
	end_m
	EVENT0in	.3,sec,.4		; 
EVENT5		
	if_m	GPIO,3,is_on,1
	  EVENT0in	.300,msec,.6
	end_m
	EVENT0in	.100,msec,.5
EVENT6	
	if_	GPIO,3,is_off,1
	  goto	EVENT0
	EVENT0in	.100,msec,.6
EVENT7		

EVENT8		

EVENT9		

EVENT10		

EVENT11		


EVENT12	
		EVENT1in .1,sec,.12	;loop

EVENT13
		
	

EVENT14 
	if_m hiSide,is_on,1
	  do_	GPIO,=,GPIO,OR,b'00000100',lit8
	else_m
	  do_	GPIO,=,GPIO,OR,b'00010000',lit8
	end_m

	EVENT0in	.4900,usec,1		;half half wave

	cblock
      Ccp:2,Count
	endc

#define v_used 2


startup
		eq_	Count,=,.30,lit8
		eq_ Ccp,=,0x0101,lit16
sloop
        bsf	GPIO,5
		exec_vardelay	Ccp
		delay .10
		bcf GPIO,5
		comf	Ccp,f
		exec_vardelay	Ccp
		comf	Ccp,f
		incf	Ccp,f
		decfsz Count,f
         goto sloop
		retlw 0


EVENT15 

		call 	startup
		call 	flflop
		delay 	.50
		do_		GPIO,=,GPIO,AND,b'11001000',lit8	;
		call 	flflop
		delay 	.50
		do_		GPIO,=,GPIO,AND,b'11001000',lit8	;
		call 	startup
		EVENT1in	.5,sec,0xFF
		eq_		NmbrEvent1,=,.12,lit8
		goto $

mxloop
	
	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1	
	eq_	ADCON0,=,ADCON1init,lit8

	do_		CcDelay,=,ADRESH,*,.4,lit8
	eq_		CcDelay+1,=,STACK,byte
							;	eq_		CcDelay,=,.64,lit16
	incf	CcDelay,f
	incf	CcDelay+1,f

	bsf	ADCON0,GO
	btfsc	ADCON0,GO
	 goto	$-1	
    eq_	ADCON0,=,ADCON0init,lit8

	do_		CcPulse,=,ADRESH,*,.2,lit8
	eq_		CcPulse+1,=,STACK,byte
							;	eq_		CcPulse,=,.164,lit16
	incf	CcPulse,f
	incf	CcPulse+1,f

	
	
loop
		if_	GPIO,3,is_off,1			; voltage on main Capacitor on
		  goto  $-1
		do_	GPIO,=,GPIO,AND,b'11001000',lit8
		call flflop
		exec_vardelay	CcDelay
        bsf	GPIO,5
		exec_vardelay	CcPulse
		bcf	GPIO,5
		delay	.4000

		

		decfsz	Count,F
         goto	loop

		goto	mxloop
	

	end